-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
--	
--	Projection Mod Helper Functions
--
--	Created: April 21, 2004
--
--	Author :  Michael Russo
--
-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------

-- MODIFY THIS AT YOUR OWN RISK
 

--
--	GetPModObjectNames
--
--	For a given Projection Modifier, return an array of the name of the Geometry Selections
--
function GetPModObjectNames pmod =
(
	local ObjList = #()
	
	pmodInterface = pmod.ProjectionModOps
	if pmodInterface == undefined do return ObjList
	
	local iObjCount = pmodInterface.NumObjects()
	ObjList.count = iObjCount 
	
	for i = 1 to iObjCount do 
		ObjList[i]= pmodInterface.GetObjectName i
	
	return ObjList
)

--
--	FindPMod
--
function FindPMod nodeSrc =
(
	local pmod = undefined
	theMods = nodeSrc.modifiers
	
	for theMod in theMods while pmod == undefined do (
		if (Classof theMod) == Projection do pmod = theMod
	)
	
	return pmod
)


--
--	AddPModObjects
--
--	nodeList : Array of nodes to apply Projection Modifiers
--	bCreateNewPMods : set to true to always append a new Projection Modifier, else use the highest in stack
--	bDeletaAll : before adding objList (targets), make sure the object list in projection modifier is empty
--	objList : if defined, these objects will be added to projection modifier, else use selectByName dialog
--
--	Array of PMods corresponding to nodeList is returned.
--
function AddPModObjects nodeList bCreateNewPMods bDeleteAll objList:undefined =
(
	local PModList = #()
	
	-- Add PMods
	for nodeSrc in nodeList do (
		local newPMod = undefined
		if bCreateNewPMods == false do (
			newPMod = FindPMod nodeSrc		
		)
		if newPMod == undefined do (
			newPMod = Projection()
			AddModifier nodeSrc newPMod
		)
		append PModList newPMod
	)

	-- Prompt for obj nodes
	if objList == undefined do (
		function selectFilter obj = iskindof obj GeometryClass
		objList = selectByName title:~OBJLIST_TITLE~ buttonText:~OBJLIST_BUTTONTEXT_CAPTION~ filter:selectFilter showhidden:false single:false
	)

	for pmod in PModList do (
		if pmod != undefined do (
			local pmodInterface = pmod.projectionmodops
			if bDeleteAll == true do pmodInterface.deleteAll()
			for objNode in objList do (
				 pmodInterface.AddObjectNode objNode
			)
		)
	)
	
	return PModList
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQDJbbUaqFEwwz/6JrORmWoMaFycmZNXOD+b
-- bmtDRrQmGla3qQWcC0CMuXxsF43wxC0oON8z4cGbnBPCPQYo+RWMh/HFYdciULIf
-- qloIdMN/khyMOpLYhpUfLAelE0EGFb6bfJCEwHmIjGFVo1CXO6VQNtgAY2R0r387
-- P917eFgUE/9srNjlksC3Noh7kuOYE7r5Uk0Cp5ZBzB5RwxMb9ERCj48YGNrgRNmA
-- CRyNpHal8TLDBYCptTS/1AXJXiLQqwX1jYKaehgTW6rWZPtydWkrmUm+86y6rmiX
-- lzy1sjxadH2OMt3myj+PHqZ9xS5f3rPwESPL+TE5oNczGarp/Pnt
-- -----END-SIGNATURE-----